/*******************************************************************************
*                         USB4ALLAPI Library Version 1.0                       *
*******************************************************************************/
#include "DriverLibUsbWin32.h"
#include _iPLATFORMLAYER_

DriverLibUsbWin32::DriverLibUsbWin32 () {

    vid = _LIBUSBWIN32_VID;
    pid = _LIBUSBWIN32_PID;
    l = log::instance();
    pl = new _iPLATFORMLAYER();
    findU4ABoards();
}

DriverLibUsbWin32::~DriverLibUsbWin32() {

    l = NULL;
    delete pl;
}

void DriverLibUsbWin32::findU4ABoards() {

    map<int,itemDsc> dscs;
    map<int,itemDsc>::iterator it;
    itemDsc ds;
    itemBoard itb;
    dscEndpoint ep;
    int temp, num;

    struct usb_bus *busses, *bus;
    struct usb_device *dev;
    struct usb_dev_handle *b;

    dscs = pl->getDescriptors();
    usb_init();
    usb_find_busses();
    usb_find_devices();
    busses = usb_get_busses();

    for (it = dscs.begin();it != dscs.end();it++) {
        ds = it->second;
        itb.serial = atoi((const char *)&ds.strSerialNumber[0]);
        itb.qtyep = ds.qtyep;
        // Obtengo el device del libusbwin32.
        char buf[255];
        for (bus = busses; bus; bus = bus->next) {
            for (dev = bus->devices; dev; dev = dev->next) {
                if(dev->descriptor.idVendor == vid && dev->descriptor.idProduct == pid){
                    b = usb_open(dev);
                    usb_get_string_simple(b, dev->descriptor.iSerialNumber, buf, 255);
                    if (itb.serial == atoi((const char *)&buf[0])) {
                        usb_set_configuration(b,1);
                        usb_claim_interface(b,0);
                        itb.devhnd = b;
                    }
                }
            }
        }
        for (int i=0 ; i < itb.qtyep ; i++){
            temp = (int)(((unsigned char)ds.stdEndpointDsc[i][3]) & 0x03);
            num = (int)((unsigned char)ds.stdEndpointDsc[i][2]);
            switch (temp) {
                case 0:
                    if (num > 127) {
                        ep.tdscin = CTRL_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                       ep.tdscin = NULL_IN;
                        ep.tdscout = CTRL_OUT;
                   }
                    break;
                case 1:
                    if (num > 127) {
                        ep.tdscin = ISO_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = ISO_OUT;
                    }
                    break;
                case 2:
                    if (num > 127) {
                        ep.tdscin = BULK_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = BULK_OUT;
                    }
                    break;
                case 3:
                    if (num > 127) {
                        ep.tdscin = INT_IN;
                        ep.tdscout = NULL_OUT;
                        num -= 128;
                    }
                    else {
                        ep.tdscin = NULL_IN;
                        ep.tdscout = INT_OUT;
                    }
                    break;
            }
            ep.epnum = num;
            itb.eps[i] = ep;
        };
        boards.insert(pair<int,itemBoard>(it->first,itb));
    }
}

struct usb_dev_handle* DriverLibUsbWin32::getInstance(int board) {

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return it->second.devhnd;

}

int DriverLibUsbWin32::unBuildBoardPart(int buffer) {

    return ((int)(buffer / 1000));
}

int DriverLibUsbWin32::unBuildDscPart(int buffer) {

    return ((int) (buffer%1000));
}

int* DriverLibUsbWin32::getU4ABoards(int& cant) {

    int *iboards;
    map<int,itemBoard>::iterator it;

    cant = boards.size();
    if (cant > 0) {
        iboards = new int[cant];
        for (int i=0; i < cant ; i++) {
            it = boards.find(i);
            iboards[i] = it->second.serial;
        };
        return iboards;
    };
    return NULL;
}

int DriverLibUsbWin32::qtyDsc(int board) {

    map<int,itemBoard>::iterator it;

    it = boards.find(board);
    return (it->second.qtyep);
}

dscEndpoint* DriverLibUsbWin32::getEndpointDsc(int board, int iter) {

    map<int,itemBoard>::iterator it;
    dscEndpoint* endps;

    it = boards.find(board);
    endps = new dscEndpoint();
    endps->epnum = it->second.eps[iter].epnum;
    endps->tdscin = it->second.eps[iter].tdscin;
    endps->tdscout = it->second.eps[iter].tdscout;
    return endps;
}

int DriverLibUsbWin32::openIn(int board, int dsc, int dscin) {

    int nbuff;
    char buffer[MAX_LEN_MSG];

    dscin = NULL_IN;
    nbuff = (board * 1000) + (128+dsc);
    sprintf(buffer,"Buffer: %d ready.",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

int DriverLibUsbWin32::openOut(int board, int dsc, int dscout) {

    int nbuff;
    char buffer[MAX_LEN_MSG];

    dscout = NULL_OUT;
    nbuff = (board * 1000) + dsc;
    sprintf(buffer,"Buffer: %d ready.",nbuff);
    l->printLog(buffer, true, true);
    return nbuff;
}

bool DriverLibUsbWin32::close(int buffer) {

    struct usb_dev_handle *dev;

    dev = getInstance(unBuildBoardPart(buffer));
    usb_release_interface(dev, 0);
    usb_close(dev);
    return true;
}

bool DriverLibUsbWin32::sendInt(int buffer, char *msg, int len, int timeout) {

    char temp[MAX_LEN_MSG];
    int ret;

    sprintf(temp,"DriverLayer ==> SendInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ret = usb_interrupt_write(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, len, timeout);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

bool DriverLibUsbWin32::sendCtrl(int buffer, char *msg, int len, int timeout) {

    //Evita los Warnings
    buffer = 0;
    msg = NULL;
    len = 0;
    timeout = 0;
    return false;
}

bool DriverLibUsbWin32::sendIso(int buffer, char *msg, int len, int timeout) {

    //Evita los Warnings
    buffer = 0;
    msg = NULL;
    len = 0;
    timeout = 0;
    return false;
}

bool DriverLibUsbWin32::sendBulk(int buffer, char *msg, int len, int timeout) {

    char temp[MAX_LEN_MSG];
    int ret;

    sprintf(temp,"DriverLayer ==> SendBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< len; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    ret = usb_bulk_write(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, len, timeout);
    if (ret == len) {
        return true;
    }
    else {
        return false;
    }
}

char* DriverLibUsbWin32::receiveInt(int buffer, int& recv, bool& ok, int timeout) {

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int explenrecv = MAX_LEN_MSG;

    recv = usb_interrupt_read(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, explenrecv, timeout);
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
    }
    sprintf(temp,"DriverLayer ==> ReceiveInt, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    return msg;
}

char* DriverLibUsbWin32::receiveCtrl(int buffer, int& recv, bool& ok, int timeout) {

    //Evita los Warnings
    buffer = 0;
    recv = 0;
    timeout = 0;

    char *msg = NULL;
    ok = false;
    return msg;
}

char* DriverLibUsbWin32::receiveIso(int buffer, int& recv, bool& ok, int timeout) {

    //Evita los Warnings
    buffer = 0;
    recv = 0;
    timeout = 0;

    char *msg = NULL;
    ok = false;
    return msg;
}

char* DriverLibUsbWin32::receiveBulk(int buffer, int& recv, bool& ok, int timeout) {

    char temp[MAX_LEN_MSG];
    char *msg = new char[MAX_LEN_MSG];
    int explenrecv = MAX_LEN_MSG;

    recv = usb_bulk_read(getInstance(unBuildBoardPart(buffer)), unBuildDscPart(buffer), msg, explenrecv, timeout);
    sprintf(temp,"DriverLayer ==> ReceiveBulk, Endpoint = %d",unBuildDscPart(buffer));
    l->printLog(temp, true, true);
    l->printLog("Message =",false, true);
    for (int i=0; i< recv; i++) {
        sprintf(temp," %X ",msg[i]);
        l->printLog(temp, false, false);
    };
    l->printLogLn();
    sprintf(temp,"Se recibieron %d bytes.",recv);
    l->printLog(temp, true, true);
    l->printLogLn();
    if (recv > 0) {
        ok = true;
    }
    else {
        ok = false;
        delete [] msg;
        msg = NULL;
    }
    return msg;
}
